<?php
session_start();
require_once 'config.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    try {
        $db = getDB();
        $stmt = $db->prepare("SELECT * FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($password, $user['password'])) {
            $_SESSION['admin_logged'] = true;
            $_SESSION['admin_user'] = $username;
            header('Location: index.php');
            exit;
        } else {
            $error = 'Usuário ou senha inválidos';
        }
    } catch (Exception $e) {
        $error = 'Erro ao conectar. Execute install.php primeiro.';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - IPTV Player Admin</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: #0f0f0f;
            color: #fff;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-box {
            background: #1a1a1a;
            border-radius: 16px;
            padding: 40px;
            width: 100%;
            max-width: 400px;
        }
        .logo {
            text-align: center;
            font-size: 28px;
            font-weight: bold;
            color: #e50914;
            margin-bottom: 30px;
        }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; color: #aaa; }
        .form-group input {
            width: 100%;
            padding: 14px 16px;
            border-radius: 8px;
            border: 1px solid #333;
            background: #252525;
            color: #fff;
            font-size: 16px;
        }
        .form-group input:focus { outline: none; border-color: #e50914; }
        .btn {
            width: 100%;
            padding: 14px;
            border-radius: 8px;
            border: none;
            background: #e50914;
            color: #fff;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
        }
        .btn:hover { background: #f40612; }
        .error {
            background: #4a1a1a;
            color: #f87171;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
        }
        .install-link {
            text-align: center;
            margin-top: 20px;
        }
        .install-link a { color: #888; font-size: 14px; }
    </style>
</head>
<body>
    <div class="login-box">
        <div class="logo">📺 IPTV Player</div>
        
        <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label>Usuário</label>
                <input type="text" name="username" required autofocus>
            </div>
            <div class="form-group">
                <label>Senha</label>
                <input type="password" name="password" required>
            </div>
            <button type="submit" class="btn">Entrar</button>
        </form>
        
        <div class="install-link">
            <a href="install.php">Primeira vez? Clique para instalar</a>
        </div>
    </div>
</body>
</html>
