<?php
// Script de instalação - cria o banco e tabelas

$host = 'localhost';
$user = 'root';
$pass = '';

try {
    $pdo = new PDO("mysql:host=$host", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Criar banco
    $pdo->exec("CREATE DATABASE IF NOT EXISTS iptv_player CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    $pdo->exec("USE iptv_player");
    
    // Tabela de playlists
    $pdo->exec("CREATE TABLE IF NOT EXISTS playlists (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(255) NOT NULL,
        url TEXT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");
    
    // Tabela de canais
    $pdo->exec("CREATE TABLE IF NOT EXISTS channels (
        id INT AUTO_INCREMENT PRIMARY KEY,
        playlist_id INT NOT NULL,
        name VARCHAR(255) NOT NULL,
        logo TEXT,
        group_name VARCHAR(255) DEFAULT 'Geral',
        url TEXT NOT NULL,
        FOREIGN KEY (playlist_id) REFERENCES playlists(id) ON DELETE CASCADE
    )");
    
    // Tabela de usuários admin
    $pdo->exec("CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(100) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");
    
    // Tabela de licenças
    $pdo->exec("CREATE TABLE IF NOT EXISTS licenses (
        id INT AUTO_INCREMENT PRIMARY KEY,
        license_key VARCHAR(50) UNIQUE NOT NULL,
        device_id VARCHAR(255) DEFAULT NULL,
        device_name VARCHAR(255) DEFAULT NULL,
        status ENUM('active', 'inactive', 'expired') DEFAULT 'active',
        expires_at DATE DEFAULT NULL,
        max_devices INT DEFAULT 1,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        activated_at TIMESTAMP NULL
    )");
    
    // Criar usuário admin padrão (senha: admin123)
    $hash = password_hash('admin123', PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT IGNORE INTO users (username, password) VALUES ('admin', ?)");
    $stmt->execute([$hash]);
    
    echo "<h1>✅ Instalação concluída!</h1>";
    echo "<p>Banco de dados e tabelas criados com sucesso.</p>";
    echo "<p><strong>Usuário:</strong> admin</p>";
    echo "<p><strong>Senha:</strong> admin123</p>";
    echo "<p><a href='index.php'>Ir para o painel</a></p>";
    
} catch (PDOException $e) {
    die("<h1>❌ Erro na instalação</h1><p>" . $e->getMessage() . "</p>");
}
